(*|  1:07 29/06/1996 *)
{$M 16384, 0, 655360}
PROGRAM TVCD;
{ From Turbo Pascal 6.0 Techniques and Utilities, by Neil J Rubenking }
{ Modified June 1993 by B Whitnall }
{ Modified Feb 1994 by B Whitnall }
{ Rewritten Mar 1994 by B Whitnall to move action from MyApp.Init to Run }
{ Modified May 1994 by B Whitnall. Zip viewer and DirNameLen const }
{ Modified June 1994 by B Whitnall to include gadgets, SHOWFREE conditional}
{ Modified May 1995 by B Whitnall. ViewTree added }
{ Modified June 1995 by B Whitnall. Added VTOC handling for PCW CD's}
{ Modified Feb 1996 by B Whitnall. DisposeStr added for redundant text}

USES
  Dos, Views, Menus, App, Objects, Dialogs, Drivers,
  StdDlg, ViewText, MsgBox, Gadgets, ViewZip, DirCollection, ViewTree;

CONST
  FileDir: String[50] = 'C:\TVCD\';
  cmAbout = 100;
{$IFDEF SHOWFREE}
  cmFreeSpace = 101;
{$ENDIF}
  cmShowBBS = 102;
  cmShowDir = 103;
  cmShowTree = 104;
  cmShowBBSD = 105;
  cmChangeDir = 106;
  cmDontChange = 107;
  cmRebuild = 108;
  cmKeyHelp = 109;

TYPE
  TOpenApp = OBJECT(TApplication)
    CONSTRUCTOR Init(OpenMask: String);
  END;
  TCDApp = OBJECT(TApplication)
    Clock: PCLockView;
    Heap: PHeapView;
    CONSTRUCTOR Init(VolName: String);
    PROCEDURE HandleEvent(VAR Event: TEvent); VIRTUAL;
    PROCEDURE InitMenuBar; VIRTUAL;
    PROCEDURE InitStatusLine; VIRTUAL;
    PROCEDURE Idle; VIRTUAL;
    PRIVATE
    PROCEDURE DoAbout;
{$IFDEF SHOWFREE}
    PROCEDURE DoFreeSpace;
{$ENDIF}
    PROCEDURE DoShowBBS(FileName: PathStr);
    PROCEDURE DoShowDir;
    PROCEDURE DoShowTree;
    PROCEDURE DoRebuild;
    PROCEDURE DoKeyHelp;
  END;
  PWListBox = ^TWListBox;
  TWListBox = OBJECT(TListBox)
    FUNCTION GetPalette: PPalette; VIRTUAL;
  END;

VAR
  MyOpen: TOpenApp;
  MyApp: TCDApp;
  ParamRebuild: Boolean;
  DoView: Boolean;
  DoHelp: Boolean;
  DoText: Boolean;
  DoSelect: Boolean;

  InitDirIndex : Word;
  FileName: String;
  CDDrive,CDString,OriginalPath: String;

{Tree Window Pointers}
  PW: PWindow;
  PS: PScrollBar;
  PWL: PWListBox;
  RPWL: TRect;

PROCEDURE DoChangeDir(DirIndex: Word);
BEGIN
  CDString := PString(DosDirCol.At(DirIndex))^;
{$I-}
  ChDir(CDString);
{$I+}
  IF IOResult <> 0 THEN
    ;
END;  { DoChangeDir }

PROCEDURE SetToCurrent;
VAR
  CurDir: String;
  L: Integer;
  P: Pointer;
  SearchCount: Integer;

  FUNCTION EqualsCur(P: PString): Boolean; far;
  BEGIN
    INC(SearchCount);
    EqualsCur := (P^ = CurDir);
  END;  { EqualsCur }

BEGIN
  GetDir(0,CurDir);
  L := Length(CurDir);
  IF L > 3 THEN BEGIN
    { remove drive code, eg C: }
    MOVE(CurDir[3], CurDir[1], L-2);
    CurDir[L] := #0;
    CurDir[L-1] := #0;
    DEC(CurDir[0], 2);
    SearchCount := -1;
    P := DosDirCol.FirstThat(@EqualsCur);
    IF SearchCount < DosDirCol.Count THEN
      PWL^.FocusItem(SearchCount);
  END;
END;  { SetToCurrent }

FUNCTION TWListBox.GetPalette: PPalette;
CONST
  CCDListBox = #6#6#7#7#7;
  P: STRING[Length(CCDListBox)] = CCDListBox;
BEGIN
  GetPalette := @P;
END;  { TWListBox.GetPalette }

CONSTRUCTOR TOpenApp.Init(OpenMask: String);
VAR
  FileDialog: PFileDialog;
  TheFile: FNameStr;
  E: TEvent;
  P: Integer;
CONST
  FDOptions: Word = fdOKButton;
BEGIN
  Inherited Init;
  TheFile := FileDir+OpenMask;
  New(FileDialog, Init(TheFile, 'Select CD Name', '~F~ile name',
    FDOptions, 1));
  IF ExecuteDialog(FileDialog, @TheFile) = cmCancel THEN
    HALT(1)
  ELSE BEGIN
    FileName := TheFile;
    REPEAT
      P :=  POS('\',FileName);
      IF P > 0 THEN
        System.DELETE(FileName, 1, P);
    UNTIL P = 0;
  END;

  {end this app}
  E.What := evCommand;
  E.Command := cmQuit;
  PutEvent(E);
END;

PROCEDURE TCDApp.DoAbout;
BEGIN
  MessageBox(#3'Turbo Vision Change Directory'#13 +
             #3'v2.3  Copyright June 1995'#13#3'B Whitnall',
             nil, mfInformation or mfOKButton);
END;  { TCDApp.DoAbout }

{$IFDEF SHOWFREE}
PROCEDURE TCDApp.DoFreeSpace;
VAR
  MemNow: LongInt;
BEGIN
  MemNow := MaxAvail;
  MessageBox(#3'Free Space'#13 +
             #3'%d',
             Addr(MemNow), mfInformation or mfOKButton);
END;  { TCDApp.DoFreeSpace }
{$ENDIF}

PROCEDURE TCDApp.DoShowDir;
VAR
  R: TRect;
  FileDialog: PFileDialog;
  TheFile: FNameStr;
  TheFileDir: DirStr;
  TheFileName: NameStr;
  TheFileExt: ExtStr;
  TextWindow: PTextWindow;
CONST
  FDOptions: Word = fdOKButton or fdOpenButton;
BEGIN
  DoChangeDir(PWL^.Focused);
  TheFile := '*.*';
  New(FileDialog, Init(TheFile, 'View file', '~F~ile name',
    FDOptions, 1));
  IF ExecuteDialog(FileDialog, @TheFile) <> cmCancel THEN BEGIN
    DeskTop^.GetExtent(R);
    R.Grow(-1, -1);
    FSplit(TheFile, TheFileDir, TheFileName, TheFileExt);
    IF (TheFileExt = '.ZIP') OR (TheFileExt = '.ARJ') OR
       (TheFileExt = '.ARC') OR (TheFileExt = '.LZH')THEN BEGIN
      R.Grow(-10, 0);
      DeskTop^.Insert(New(PZipWindow, Init(R, TheFile)));
    END ELSE
      DeskTop^.Insert(New(PTextWindow, Init(R, TheFile)));
  END;
END;  { TCDApp.DoShowDir }

PROCEDURE TCDApp.DoShowBBS(FileName: PathStr);
VAR
  SR: SearchRec;
  R: TRect;
  TextWindow: PTextWindow;
  PS: PString;
BEGIN
  DoChangeDir(PWL^.Focused);
  FindFirst(FileName, AnyFile, SR);
  IF DosError <> 0 THEN BEGIN
    NEW(PS);
    PS^ := FileName;
    MessageBox(#3'Unable to find file'#13 +
               #3'%s', @PS,  mfError + mfOKButton);
    DISPOSE(PS);
  END ELSE BEGIN
    DeskTop^.GetExtent(R);
    R.Grow(0,-2);
    DeskTop^.Insert(New(PTextWindow, Init(R, SR.Name)));
  END;
END;  { TCDApp.DoShowBBS }

PROCEDURE TCDApp.DoShowTree;
VAR
  R: TRect;
  PW: PWindow;
  PS: PScrollBar;
BEGIN
  DeskTop^.GetExtent(R);
{ R.Grow(-1,-1);}
  New(PW, Init(R, 'Directory Tree', wnNoNumber));
  PW^.Flags := wfMove + wfClose;

  PS := PW^.StandardScrollBar(sbVertical+sbHandleKeyBoard);

  WITH PW^ DO
    R.Assign(1, 1, Size.X-1, Size.Y-1);
  PWL := New(PWListBox, Init(R, 1, PS));
  PWL^.NewList(@DirCol);
  PW^.Insert(PWL);
  DeskTop^.Insert(PW);
  SetToCurrent;
END;  { TCDApp.DoShowTree }

PROCEDURE TCDApp.DoRebuild;
BEGIN
  PW^.Delete(PWL);
  PWL^.Done;
  DirCol.Done;
  DosDirCol.Done;
  LoadDirCol(FileDir, FileName, True);
  PWL := New(PWListBox, Init(RPWL, 1, PS));
  PWL^.NewList(@DirCol);
  PW^.Insert(PWL);
END;  { TCDApp.DoRebuild }

PROCEDURE TCDApp.DoKeyHelp;
BEGIN
  MessageBox(#3'Dir          F3'#13+
{            #3'Tree   Shift F3'#13+}
             #3'*.BBS        F4'#13+
             #3'*.Dir    Alt F4',
             nil, mfInformation or mfOKButton);
END;  { TCDApp.DoKeyHelp }

PROCEDURE TCDApp.InitMenuBar;
VAR
  R: TRect;
BEGIN
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  Menubar := New(PMenuBar, Init(R, NewMenu(
    NewItem('*.~B~BS', '', kbF4, cmShowBBS, hcNoContext,
    NewItem('~D~ir', '', kbF3, cmShowDir, hcNoContext,
    NewItem('*.Di~r~', '', kbAltF4, cmShowBBSD, hcNoContext,
{   NewItem('~T~ree', '', kbShiftF3, cmShowTree, hcNoContext,}
    NewItem('R~e~build','', kbNokey, cmRebuild, hcNoContext,
    NewSubMenu('~W~indow', hcNoContext, NewMenu(
      NewItem('~T~ile', '', kbNoKey, cmTile, hcNoContext,
      NewItem('C~a~scade', '', kbNoKey, cmCascade, hcNoContext,
      NewLine(
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
      NewItem('~C~lose', 'Alt+F3', kbAltF3, cmClose, hcNoContext,
      nil))))))),
    NewSubMenu('~H~elp', hcNoContext, NewMenu(
      NewItem('~A~bout', 'F1', kbF1, cmAbout, hcNoContext,
      NewItem('~K~eys', 'Shift+F1' , kbShiftF1, cmKeyHelp, hcNoContext,
{$IFDEF SHOWFREE}
      NewItem('~F~ree', 'Alt+F1', kbAltF1, cmFreeSpace, hcNoContext,
{$ENDIF}
      nil
{$IFDEF SHOWFREE}
      )
{$ENDIF}
      ))),
  nil)))))))));
END;  { TCDApp.InitMenuBar }

PROCEDURE TCDApp.InitStatusLine;
VAR
  R: TRect;
BEGIN
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R, NewStatusDef(0, $FFFF,
    NewStatusKey('', kbF10, cmMenu,
{   NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,}
    NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
    NewStatusKey('~F9~ ChangeDir', kbF9, cmChangeDir,
    NewStatusKey('~Alt-F9~ NoChange', kbAltF9, cmDontChange,
    nil)))),
  nil)));
END;  { TCDApp.InitStatusLine }

CONSTRUCTOR TCDApp.Init(VolName: String);
VAR
  R: TRect;
BEGIN
  Inherited Init;

  Clock := NIL;
  Heap := NIL;

  GetExtent(R);
  R.A.X := R.B.X - 9;
  R.B.Y := R.A.Y + 1;
  NEW(Clock, INIT(R));
  Insert(Clock);

  GetExtent(R);
  DEC(R.B.X);
  R.A.X := R.B.X - 9;
  R.A.Y := R.B.Y - 1;
  NEW(Heap, INIT(R));
  Insert(Heap);

  DeskTop^.GetExtent(R);
{ R.Grow(-5,0);}
  New(PW, Init(R, 'Directory Tree of ' + VolName, wnNoNumber));
  PW^.Flags := wfMove{ + wfClose};

  PS := PW^.StandardScrollBar(sbVertical+sbHandleKeyBoard);
{
  PS^.GetBounds(R);
  DEC(R.B.Y, 3);
  PS^.ChangeBounds(R);
}
  WITH PW^ DO
    R.Assign(1, 1, Size.X-1, Size.Y-1);
  RPWL := R;
  PWL := New(PWListBox, Init(R, 1, PS));
  PWL^.NewList(@DirCol);
  PW^.Insert(PWL);
  DeskTop^.Insert(PW);
  SetToCurrent;
  InitDirIndex := PWL^.Focused;
END;  { TCDApp.Init }

PROCEDURE TCDApp.HandleEvent(VAR Event: TEvent);
VAR
  E: TEvent;
BEGIN
  Inherited HandleEvent(Event);
  IF Event.What = evCommand THEN BEGIN
    CASE Event.Command OF
      cmShowBBS: DoShowBBS('*.BBS');
      cmShowBBSD: DoShowBBS('*.DIR');
      cmShowDir: DoShowDir;
      cmShowTree: DoShowTree;
      cmAbout: DoAbout;
{$IFDEF SHOWFREE}
      cmFreeSpace: DoFreeSpace;
{$ENDIF}
      cmRebuild: DoRebuild;
      cmKeyHelp: DoKeyHelp;
      cmChangeDir: BEGIN
                     DoChangeDir(PWL^.Focused);
                     SetToCurrent;
                     E.What := evCommand;
                     E.Command := cmQuit;
                     PutEvent(E);  { force Quit }
                   END;
      cmDontChange: BEGIN
(*
                      DoChangeDir(InitDirIndex);
                      SetToCurrent;
*)
                      ChDir(OriginalPath);
                      E.What := evCommand;
                      E.Command := cmQuit;
                      PutEvent(E);  { force Quit }
                    END;
    ELSE
      Exit;
    END;
    ClearEvent(Event);
  END;
END;  { TCDApp.HandleEvent }

PROCEDURE TCDApp.Idle;
BEGIN
  Inherited Idle;
  IF Clock <> Nil THEN
    Clock^.Update;
  IF Heap <> Nil THEN
    Heap^.Update;
END;  { TCDApp.Idle }

FUNCTION VolSetIdent: STRING;
CONST
  IntMPlex   = $2F;
  FuncCDRom  = $15;
  CDCheck    = $00;
  CDReadVTOC = $05;
VAR
  Regs: Registers;
  VTOCBuffer: ARRAY[1..2048] OF CHAR;
  L: INTEGER;
  Done: BOOLEAN;
  Result: STRING[128];
BEGIN
  WITH Regs DO BEGIN
    AH := FuncCDRom;
    AL := CDCheck;
    INTR(IntMPlex, Regs);
    AH := FuncCDRom;
    AL := CDReadVTOC;
    BX := Ofs(VTOCBuffer);
    ES := Seg(VTOCBuffer);
    DX := 0;            { first volume descriptor }
    INTR(IntMPlex, Regs);
  END;
  MOVE(VTOCBuffer[191], Result[1], 128);
  L := 128;
  Result[0] := #128;
  Done := FALSE;
  REPEAT
    IF Result[L] <> ' ' THEN
      Done := TRUE
    ELSE
      DEC(L);
   IF L = 0 THEN
     Done := TRUE;
  UNTIL Done;
  Result[0] := CHR(L);
  VolSetIdent := Result;
END;  { VolSetIdent }

PROCEDURE SelectIt(OpenMask: String);
BEGIN
(*
  Write('Unable to indentify disk. Enter manual choice : ');
  Readln(FileName);
*)
  MyOpen.Init(OpenMask);
  MyOpen.Run;
  MyOpen.Done;
  IF Length(FileName) = 0 THEN
    Halt;
END;

PROCEDURE SetFileName(Select: Boolean);
VAR
  SR: SearchRec;
  OpenMask: String;
  P: Integer;
BEGIN
  OpenMask := '*.*';
  ChDir(CDDrive);
  FindFirst('*.*',VolumeID,SR);
  WHILE (SR.Attr AND VolumeID = 0) AND (DosError = 0) DO BEGIN
    FindNext(SR);
  END;
  IF (DosError = 0) AND (Length(SR.Name) > 0) THEN BEGIN
    FileName := SR.Name;
    IF Select THEN BEGIN
      OpenMask := SR.Name;
      P := POS('.', OpenMask);
      IF P > 1 THEN
        OpenMask := COPY(OpenMask, 1, P-1);
      OpenMask := OpenMask + '.*';
      SelectIt(OpenMask);
    END ELSE IF SR.Name = 'PCW' THEN
      FileName := FileName + VolSetIdent;
  END ELSE BEGIN
    FindFirst('\BB*.',Directory,SR);
    WHILE (SR.Attr AND Directory = 0) AND (DosError = 0) DO BEGIN
      FindNext(SR);
    END;
    IF DosError = 0 THEN
      FileName := SR.Name
    ELSE BEGIN
      IF (ParamCount > 0) AND NOT (ParamRebuild OR Select) THEN
        FileName := ParamStr(1)
      ELSE BEGIN
        SelectIt(OpenMask);
      END;
    END;
  END;
END;  { SetFileName }

PROCEDURE RunMyView(FilePath: String);
VAR
  MyViewApp: TCDViewApp;
BEGIN
  MyViewApp.Init(FilePath);
  MyViewApp.Run;
  MyViewApp.Done;
END;  { RunMyView }

FUNCTION CommandOption: CHAR;
VAR
  Result: CHAR;
  OptionString: STRING[2];
BEGIN
  Result := ' ';
  OptionString := '  ';
  IF ParamCount > 0 THEN BEGIN
    IF Length(ParamStr(1)) < 3 THEN BEGIN
      OptionString := ParamStr(1);
      IF OptionString = '?' THEN
        Result := '?'
      ELSE IF OptionString[2] = ':' THEN
        CDDrive := OptionString
      ELSE IF OptionString[1] = '/' THEN
        Result := UpCase(OptionString[2]);
    END;
  END;
  CommandOption := Result;
END;  { CommandOption }

PROCEDURE ShowHelp;
BEGIN
  Writeln('Usage : TVCD [/r|/v|/t|/?|drive:]');
  Writeln('  /r to rebuild file');
  Writeln('  /v to view existing files');
  Writeln('  /s to select existing file');
  Writeln('  /t to print existing file(s) as text');
  Writeln('  /? for this help text');
END;  { ShowHelp }

BEGIN
  CDDrive := '';
  CDString := GetEnv('TVCD');
  GetDir(0, OriginalPath);
  IF Length(CDString) > 0 THEN
    FileDir := CDString;
  IF FileDir[Length(FileDir)] <> '\' THEN
    FileDir := FileDir + '\';
  CDString := '';
  ParamRebuild := False;
  DoView := False;
  DoHelp := False;
  DoText := False;
  DoSelect := False;
  CASE CommandOption OF
    ' ' : ;
    'H','?' : DoHelp := True;
    'R' : ParamRebuild := True;
    'S' : DoSelect := True;
    'T' : DoText := True;
    'V' : DoView := True;
  ELSE
    BEGIN
      Writeln('Unrecognised option');
      DoHelp := True;
    END;
  END;
  IF DoView THEN
    RunMyView(FileDir)
  ELSE IF DoHelp THEN
    ShowHelp
  ELSE IF DoText THEN
    Writeln('/t not yet implemented')
  ELSE BEGIN
    SetFileName(DoSelect);
    CASE LoadDirCol(FileDir, FileName, ParamRebuild) OF
      0 : BEGIN
            MyApp.Init(FileName);
            MyApp.Run;
            MyApp.Done;
            DirCol.Done;
          END;
      1 : Writeln('Invalid function number');
      2 : Writeln('File not found');
      3 : Writeln('Path not found');
      4 : Writeln('Too many open files');
      5 : Writeln('File access denied');
      6 : Writeln('Invalid file handle');
      12: Writeln('Invalid file access code');
      18: Writeln('No matching files.');
    ELSE
      Writeln('Error reading directories');
    END;
  END;
  Writeln('TVCD v2.5 by N Rubenking, B Whitnall, 1993,1994,1995,1996');
  IF Length(CDString) > 0 THEN
    Write('CD ',CDString);
END.
